/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.combat.CantBeBlockedByAllTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HexproofBaseAbility;
import mage.abilities.keyword.ToxicAbility;
import mage.choices.Choice;
import mage.choices.ChoiceColor;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.players.Player;

class SkrelvDefectorMiteEffect
extends OneShotEffect {
    SkrelvDefectorMiteEffect() {
        super(Outcome.Benefit);
        this.staticText = "Choose a color. Another target creature you control gains toxic 1 and hexproof from that color until end of turn. It can't be blocked by creatures of that color this turn";
    }

    private SkrelvDefectorMiteEffect(SkrelvDefectorMiteEffect effect) {
        super((OneShotEffect)effect);
    }

    public SkrelvDefectorMiteEffect copy() {
        return new SkrelvDefectorMiteEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        ChoiceColor choice = new ChoiceColor(true);
        player.choose(this.outcome, (Choice)choice, game);
        game.addEffect((ContinuousEffect)new GainAbilityTargetEffect((Ability)new ToxicAbility(1), Duration.EndOfTurn), source);
        game.addEffect((ContinuousEffect)new GainAbilityTargetEffect((Ability)HexproofBaseAbility.getFirstFromColor((ObjectColor)choice.getColor()), Duration.EndOfTurn), source);
        FilterCreaturePermanent filter = new FilterCreaturePermanent();
        filter.add((Predicate)new ColorPredicate(choice.getColor()));
        game.addEffect((ContinuousEffect)new CantBeBlockedByAllTargetEffect(filter, Duration.EndOfTurn), source);
        return true;
    }
}

