/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class SkulkingKillerEffect
extends OneShotEffect {
    SkulkingKillerEffect() {
        super(Outcome.Benefit);
        this.staticText = "target creature an opponent controls gets -2/-2 until end of turn if that opponent controls no other creatures";
    }

    private SkulkingKillerEffect(SkulkingKillerEffect effect) {
        super((OneShotEffect)effect);
    }

    public SkulkingKillerEffect copy() {
        return new SkulkingKillerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null || game.getBattlefield().count((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, permanent.getControllerId(), source, game) > 1) {
            return false;
        }
        game.addEffect((ContinuousEffect)new BoostTargetEffect(-2, -2), source);
        return true;
    }
}

