/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentToken;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.ZombieToken;

class SkullSkaabTriggeredAbility
extends TriggeredAbilityImpl {
    SkullSkaabTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CreateTokenEffect((Token)new ZombieToken()));
    }

    private SkullSkaabTriggeredAbility(SkullSkaabTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public SkullSkaabTriggeredAbility copy() {
        return new SkullSkaabTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.EXPLOITED_CREATURE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent exploiter = game.getPermanentOrLKIBattlefield(event.getSourceId());
        Permanent exploited = game.getPermanentOrLKIBattlefield(event.getTargetId());
        return exploiter != null && exploited != null && exploiter.isCreature(game) && exploited.isCreature(game) && exploiter.isControlledBy(this.getControllerId()) && !(exploited instanceof PermanentToken);
    }

    public String getRule() {
        return "Whenever a creature you control exploits a nontoken creature, create a 2/2 black Zombie creature token.";
    }
}

