/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class SkullStormEffect
extends OneShotEffect {
    SkullStormEffect() {
        super(Outcome.Benefit);
        this.staticText = "Each opponent sacrifices a creature of their choice. Each opponent who can't loses half their life, rounded up.";
    }

    private SkullStormEffect(SkullStormEffect effect) {
        super((OneShotEffect)effect);
    }

    public SkullStormEffect copy() {
        return new SkullStormEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        game.getOpponents(source.getControllerId()).forEach(playerId -> {
            Player player = game.getPlayer(playerId);
            if (player != null) {
                FilterCreaturePermanent filter = new FilterCreaturePermanent();
                filter.add((Predicate)new ControllerIdPredicate(playerId));
                if (game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), game).isEmpty()) {
                    int lifeToLose = (int)Math.ceil((float)player.getLife() / 2.0f);
                    player.loseLife(lifeToLose, game, source, false);
                } else {
                    SacrificeEffect effect = new SacrificeEffect((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, 1, null);
                    effect.setTargetPointer((TargetPointer)new FixedTarget(playerId, game));
                    effect.apply(game, source);
                }
            }
        });
        return true;
    }
}

