/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.StaticAbility;
import mage.abilities.common.DealsCombatDamageToAPlayerTriggeredAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.abilities.keyword.HasteAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.s.SkullbriarEffect;
import mage.constants.CardType;
import mage.constants.EffectType;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.constants.Zone;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.counters.Counters;
import mage.game.Game;
import mage.game.events.ZoneChangeEvent;

public final class SkullbriarTheWalkingGrave
extends CardImpl {
    public SkullbriarTheWalkingGrave(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{B}{G}");
        this.supertype.add(SuperType.LEGENDARY);
        this.subtype.add((Object)SubType.ZOMBIE);
        this.subtype.add((Object)SubType.ELEMENTAL);
        this.power = new MageInt(1);
        this.toughness = new MageInt(1);
        this.addAbility((Ability)HasteAbility.getInstance());
        this.addAbility((Ability)new DealsCombatDamageToAPlayerTriggeredAbility((Effect)new AddCountersSourceEffect(CounterType.P1P1.createInstance()), false));
        this.addAbility((Ability)new SimpleStaticAbility(Zone.ALL, (Effect)new SkullbriarEffect()));
    }

    private SkullbriarTheWalkingGrave(SkullbriarTheWalkingGrave card) {
        super((CardImpl)card);
    }

    public SkullbriarTheWalkingGrave copy() {
        return new SkullbriarTheWalkingGrave(this);
    }

    public void updateZoneChangeCounter(Game game, ZoneChangeEvent event) {
        boolean skullBriarEffectApplied = false;
        if (event.getToZone() != Zone.HAND && event.getToZone() != Zone.LIBRARY) {
            for (StaticAbility ability : this.getAbilities(game).getStaticAbilities(event.getFromZone())) {
                for (Effect effect : ability.getEffects(game, EffectType.REPLACEMENT)) {
                    if (!(effect instanceof SkullbriarEffect) || !event.getAppliedEffects().contains(effect.getId())) continue;
                    skullBriarEffectApplied = true;
                }
            }
        }
        Counters copyFrom = null;
        if (skullBriarEffectApplied) {
            copyFrom = event.getTarget() != null && event.getFromZone() == Zone.BATTLEFIELD ? event.getTarget().getCounters(game).copy() : this.getCounters(game).copy();
        }
        super.updateZoneChangeCounter(game, event);
        Counters copyTo = null;
        if (event.getTarget() != null && event.getToZone() == Zone.BATTLEFIELD) {
            if (event.getFromZone() != Zone.BATTLEFIELD) {
                copyTo = event.getTarget().getCounters(game);
            }
        } else {
            copyTo = this.getCounters(game);
        }
        if (copyTo != null && copyFrom != null) {
            for (Counter counter : copyFrom.values()) {
                copyTo.addCounter(counter);
            }
        }
    }
}

