/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainControlAllEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class SkySwallowerEffect
extends OneShotEffect {
    SkySwallowerEffect() {
        super(Outcome.Detriment);
        this.staticText = "target opponent gains control of all other permanents you control";
    }

    private SkySwallowerEffect(SkySwallowerEffect effect) {
        super((OneShotEffect)effect);
    }

    public SkySwallowerEffect copy() {
        return new SkySwallowerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player opponent = game.getPlayer(source.getFirstTarget());
        if (opponent == null) {
            return false;
        }
        return new GainControlAllEffect(Duration.Custom, (FilterPermanent)StaticFilters.FILTER_CONTROLLED_ANOTHER_TARGET_PERMANENT, opponent.getId()).apply(game, source);
    }
}

