/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.counters.Counters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SkyshipPlundererEffect
extends OneShotEffect {
    SkyshipPlundererEffect() {
        super(Outcome.Neutral);
        this.staticText = "for each kind of counter on target permanent or player, give that permanent or player another counter of that kind";
    }

    private SkyshipPlundererEffect(SkyshipPlundererEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
            if (player != null) {
                Counters counters = player.getCountersAsCopy();
                for (Counter counter : counters.values()) {
                    CounterType counterType = CounterType.findByName((String)counter.getName());
                    Counter counterToAdd = counterType != null ? counterType.createInstance() : new Counter(counter.getName());
                    player.addCounters(counterToAdd, source.getControllerId(), source, game);
                }
                return true;
            }
            Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
            if (permanent != null) {
                Counters counters = permanent.getCounters(game).copy();
                for (Counter counter : counters.values()) {
                    CounterType counterType = CounterType.findByName((String)counter.getName());
                    Counter counterToAdd = counterType != null ? counterType.createInstance() : new Counter(counter.getName());
                    permanent.addCounters(counterToAdd, source.getControllerId(), source, game);
                }
            }
            return true;
        }
        return false;
    }

    public SkyshipPlundererEffect copy() {
        return new SkyshipPlundererEffect(this);
    }
}

