/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.ArrayList;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DontUntapInControllersNextUntapStepTargetEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class SleepEffect
extends OneShotEffect {
    SleepEffect() {
        super(Outcome.Tap);
        this.staticText = "Tap all creatures target player controls. Those creatures don't untap during that player's next untap step";
    }

    private SleepEffect(SleepEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getFirstTarget());
        if (player != null) {
            ArrayList<Permanent> doNotUntapNextUntapStep = new ArrayList<Permanent>();
            for (Permanent creature : game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, player.getId(), game)) {
                creature.tap(source, game);
                doNotUntapNextUntapStep.add(creature);
            }
            if (!doNotUntapNextUntapStep.isEmpty()) {
                DontUntapInControllersNextUntapStepTargetEffect effect = new DontUntapInControllersNextUntapStepTargetEffect("", player.getId());
                effect.setText("those creatures don't untap during that player's next untap step");
                effect.setTargetPointer((TargetPointer)new FixedTargets(doNotUntapNextUntapStep, game));
                game.addEffect((ContinuousEffect)effect, source);
            }
            return true;
        }
        return false;
    }

    public SleepEffect copy() {
        return new SleepEffect(this);
    }
}

