/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;

class SludgeMonsterEffect
extends ContinuousEffectImpl {
    private static final FilterPermanent filter = new FilterCreaturePermanent();

    SludgeMonsterEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "non-Horror creatures with slime counters on them lose all abilities and have base power and toughness 2/2";
    }

    private SludgeMonsterEffect(SludgeMonsterEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public SludgeMonsterEffect copy() {
        return new SludgeMonsterEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        for (Permanent permanent : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game)) {
            switch (layer) {
                case AbilityAddingRemovingEffects_6: {
                    permanent.removeAllAbilities(source.getSourceId(), game);
                    break;
                }
                case PTChangingEffects_7: {
                    if (sublayer != SubLayer.SetPT_7b) break;
                    permanent.getPower().setModifiedBaseValue(2);
                    permanent.getToughness().setModifiedBaseValue(2);
                }
            }
        }
        return true;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.AbilityAddingRemovingEffects_6 || layer == Layer.PTChangingEffects_7;
    }

    static {
        filter.add((Predicate)CounterType.SLIME.getPredicate());
        filter.add(Predicates.not((Predicate)SubType.HORROR.getPredicate()));
    }
}

