/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DoIfCostPaid;
import mage.cards.s.SludgeStriderEffect;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.filter.common.FilterArtifactPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;

class SludgeStriderTriggeredAbility
extends TriggeredAbilityImpl {
    private static final FilterArtifactPermanent filter = new FilterArtifactPermanent("another artifact under your control");

    public SludgeStriderTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DoIfCostPaid((Effect)new SludgeStriderEffect(), (Cost)new GenericManaCost(1)), false);
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private SludgeStriderTriggeredAbility(SludgeStriderTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD || event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent;
        Permanent permanent;
        if (event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD && (permanent = game.getPermanent(event.getTargetId())) != null && filter.match(permanent, this.getControllerId(), (Ability)this, game)) {
            return true;
        }
        if (event.getType() == GameEvent.EventType.ZONE_CHANGE && (zEvent = (ZoneChangeEvent)event).getFromZone() == Zone.BATTLEFIELD) {
            UUID targetId = event.getTargetId();
            Permanent permanent2 = game.getPermanent(targetId);
            if (permanent2 == null) {
                permanent2 = (Permanent)game.getLastKnownInformation(targetId, Zone.BATTLEFIELD);
            }
            return permanent2 != null && filter.match(permanent2, this.getControllerId(), (Ability)this, game);
        }
        return false;
    }

    public SludgeStriderTriggeredAbility copy() {
        return new SludgeStriderTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever another artifact you control enters or another artifact you control leaves the battlefield, you may pay {1}. If you do, target player loses 1 life and you gain 1 life.";
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)TargetController.YOU.getControllerPredicate());
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
    }
}

