/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardAndOrCard;

class SludgeTitanEffect
extends OneShotEffect {
    SludgeTitanEffect() {
        super(Outcome.Benefit);
        this.staticText = "mill five cards. You may put a creature card and/or a land card from among them into your hand";
    }

    private SludgeTitanEffect(SludgeTitanEffect effect) {
        super((OneShotEffect)effect);
    }

    public SludgeTitanEffect copy() {
        return new SludgeTitanEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Cards cards = controller.millCards(5, source, game);
        game.processAction();
        cards.removeIf(card -> !game.getState().getZone(card).isPublicZone());
        if (!cards.isEmpty()) {
            TargetCardAndOrCard target = new TargetCardAndOrCard(CardType.CREATURE, CardType.LAND);
            controller.choose(Outcome.DrawCard, cards, (TargetCard)target, source, game);
            CardsImpl toHand = new CardsImpl();
            toHand.addAll((Collection)target.getTargets());
            controller.moveCards((Cards)toHand, Zone.HAND, source, game);
        }
        return true;
    }
}

