/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.TreasureToken;

class SmashingSuccessEffect
extends OneShotEffect {
    SmashingSuccessEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy target artifact or land. If an artifact is destroyed this way, create a Treasure token.";
    }

    private SmashingSuccessEffect(SmashingSuccessEffect effect) {
        super((OneShotEffect)effect);
    }

    public SmashingSuccessEffect copy() {
        return new SmashingSuccessEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent != null && permanent.isPhasedIn()) {
            if (permanent.isArtifact(game)) {
                if (permanent.destroy(source, game, false)) {
                    TreasureToken token = new TreasureToken();
                    token.putOntoBattlefield(1, game, source, source.getControllerId());
                    return true;
                }
            } else {
                return permanent.destroy(source, game, false);
            }
        }
        return false;
    }
}

