/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.s.SmeltingVatTarget;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class SmeltingVatEffect
extends OneShotEffect {
    SmeltingVatEffect() {
        super(Outcome.Benefit);
        this.staticText = "reveal the top eight cards of your library. Put up to two noncreature artifact cards with total mana value less than or equal to the sacrificed artifact's mana value from among them onto the battlefield and the rest on the bottom of your library in a random order";
    }

    private SmeltingVatEffect(SmeltingVatEffect effect) {
        super((OneShotEffect)effect);
    }

    public SmeltingVatEffect copy() {
        return new SmeltingVatEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 8));
        player.revealCards(source, (Cards)cards, game);
        SmeltingVatTarget target = new SmeltingVatTarget(source);
        player.choose(this.outcome, (Cards)cards, (TargetCard)target, source, game);
        player.moveCards((Cards)new CardsImpl((Collection)target.getTargets()), Zone.BATTLEFIELD, source, game);
        cards.retainZone(Zone.LIBRARY, game);
        player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        return true;
    }
}

