/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;

class SmileAtDeathEffect
extends OneShotEffect {
    SmileAtDeathEffect() {
        super(Outcome.Benefit);
        this.staticText = "return up to two target creature cards with power 2 or less from your graveyard to the battlefield. Put a +1/+1 counter on each of those creatures";
    }

    private SmileAtDeathEffect(SmileAtDeathEffect effect) {
        super((OneShotEffect)effect);
    }

    public SmileAtDeathEffect copy() {
        return new SmileAtDeathEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl((Collection)this.getTargetPointer().getTargets(game, source));
        cards.retainZone(Zone.GRAVEYARD, game);
        if (cards.isEmpty()) {
            return false;
        }
        player.moveCards((Cards)cards, Zone.BATTLEFIELD, source, game);
        for (UUID cardId : cards) {
            Optional.ofNullable(cardId).map(arg_0 -> ((Game)game).getPermanent(arg_0)).ifPresent(permanent -> permanent.addCounters(CounterType.P1P1.createInstance(), source, game));
        }
        return true;
    }
}

