/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.constants.SuperType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterLandPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

enum SnowblindValue implements DynamicValue
{
    instanceX,
    instanceY;

    private static final FilterPermanent filter;

    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        Permanent sourcePerm = game.getPermanent(sourceAbility.getSourceId());
        if (sourcePerm == null) {
            return 0;
        }
        Permanent permanent = game.getPermanent(sourcePerm.getAttachedTo());
        if (permanent == null) {
            return 0;
        }
        int xValue = 0;
        xValue = permanent.isAttacking() ? game.getBattlefield().countAll(filter, game.getCombat().getDefendingPlayerId(permanent.getId(), game), game) : game.getBattlefield().countAll(filter, permanent.getControllerId(), game);
        if (this == instanceX) {
            return -xValue;
        }
        return -Math.min(xValue, permanent.getToughness().getValue() - 1);
    }

    public DynamicValue copy() {
        return this;
    }

    public String getMessage() {
        return "";
    }

    static {
        filter = new FilterLandPermanent();
        filter.add((Predicate)SuperType.SNOW.getPredicate());
    }
}

