/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.mana.ManaEffect;
import mage.cards.s.SnowfallConditionalMana;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SnowfallManaEffect
extends ManaEffect {
    private static final Set<String> choice = new HashSet<String>();

    SnowfallManaEffect() {
        this.staticText = "its controller may add an additional {U}. If that Island is snow, its controller may add an additional {U}{U} instead. Spend this mana only to pay cumulative upkeep costs.";
    }

    private SnowfallManaEffect(SnowfallManaEffect effect) {
        super((ManaEffect)effect);
    }

    public Player getPlayer(Game game, Ability source) {
        Permanent land = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (land != null) {
            return game.getPlayer(land.getControllerId());
        }
        return null;
    }

    public List<Mana> getNetMana(Game game, Ability source) {
        ArrayList<Mana> netMana = new ArrayList<Mana>();
        if (game == null) {
            return netMana;
        }
        Permanent land = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (land == null) {
            return netMana;
        }
        Mana mana = Mana.BlueMana((int)(land.isSnow(game) ? 2 : 1));
        netMana.add(mana);
        return netMana;
    }

    public Mana produceMana(Game game, Ability source) {
        if (game == null) {
            return new Mana();
        }
        Permanent land = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (land == null) {
            return new Mana();
        }
        Player player = game.getPlayer(land.getControllerId());
        if (player == null) {
            return new Mana();
        }
        if (land.isSnow(game)) {
            ChoiceImpl choiceImpl = new ChoiceImpl(false);
            choiceImpl.setMessage("Add additional blue mana? This mana can only be spent to pay cumulative upkeep costs.");
            choiceImpl.setChoices(choice);
            if (player.choose(this.outcome, (Choice)choiceImpl, game)) {
                switch (choiceImpl.getChoice()) {
                    case "Add one additional blue mana.": {
                        return new SnowfallConditionalMana(Mana.BlueMana((int)1));
                    }
                    case "Add two additional blue mana.": {
                        return new SnowfallConditionalMana(Mana.BlueMana((int)2));
                    }
                }
            }
        } else {
            String message = "Add an additional {U}? This mana can only be spent to pay cumulative upkeep costs.";
            if (player.chooseUse(this.outcome, message, source, game)) {
                return new SnowfallConditionalMana(Mana.BlueMana((int)1));
            }
        }
        return new Mana();
    }

    public SnowfallManaEffect copy() {
        return new SnowfallManaEffect(this);
    }

    static {
        choice.add("Add one additional blue mana.");
        choice.add("Add two additional blue mana.");
        choice.add("Don't add additional mana.");
    }
}

