/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectData;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SoltariGuerrillasReplacementEffect
extends PreventionEffectImpl {
    SoltariGuerrillasReplacementEffect() {
        super(Duration.EndOfTurn, Integer.MAX_VALUE, true, false);
        this.staticText = "The next time {this} would deal combat damage to an opponent this turn, it deals that damage to target creature instead";
    }

    private SoltariGuerrillasReplacementEffect(SoltariGuerrillasReplacementEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PLAYER;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Player controller;
        if (event.getSourceId().equals(source.getSourceId()) && (controller = game.getPlayer(source.getControllerId())) != null) {
            return controller.hasOpponent(event.getTargetId(), game);
        }
        return false;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        PreventionEffectData preventionResult = this.preventDamageAction(event, source, game);
        if (preventionResult.getPreventedDamage() > 0) {
            Permanent redirectTo = game.getPermanent(this.getTargetPointer().getFirst(game, source));
            if (redirectTo != null) {
                game.informPlayers("Dealing " + preventionResult.getPreventedDamage() + " to " + redirectTo.getLogName() + " instead.");
                DamageEvent damageEvent = (DamageEvent)event;
                redirectTo.damage(preventionResult.getPreventedDamage(), event.getSourceId(), source, game, damageEvent.isCombatDamage(), damageEvent.isPreventable(), event.getAppliedEffects());
            }
            this.discard();
        }
        return false;
    }

    public SoltariGuerrillasReplacementEffect copy() {
        return new SoltariGuerrillasReplacementEffect(this);
    }
}

