/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.PermanentsOnTheBattlefieldCondition;
import mage.abilities.decorator.ConditionalOneShotEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.abilities.hint.ConditionHint;
import mage.abilities.hint.Hint;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.AttackingPredicate;
import mage.filter.predicate.permanent.BlockingPredicate;
import mage.filter.predicate.permanent.TappedPredicate;
import mage.target.Target;
import mage.target.TargetPermanent;

public final class SonarStrike
extends CardImpl {
    private static final FilterPermanent filter = new FilterCreaturePermanent("attacking, blocking, or tapped creature");
    private static final Condition condition;
    private static final Hint hint;

    public SonarStrike(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{1}{W}");
        this.getSpellAbility().addEffect((Effect)new DamageTargetEffect(4));
        this.getSpellAbility().addTarget((Target)new TargetPermanent(filter));
        this.getSpellAbility().addEffect((Effect)new ConditionalOneShotEffect((OneShotEffect)new GainLifeEffect(3), condition, "you gain 3 life if you control a Bat"));
        this.getSpellAbility().addHint(hint);
    }

    private SonarStrike(SonarStrike card) {
        super((CardImpl)card);
    }

    public SonarStrike copy() {
        return new SonarStrike(this);
    }

    static {
        filter.add(Predicates.or((Predicate[])new Predicate[]{AttackingPredicate.instance, BlockingPredicate.instance, TappedPredicate.TAPPED}));
        condition = new PermanentsOnTheBattlefieldCondition((FilterPermanent)new FilterControlledPermanent(SubType.BAT));
        hint = new ConditionHint(condition, "You control a Bat");
    }
}

