/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class SongOfInspirationEffect
extends OneShotEffect {
    SongOfInspirationEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose up to two target permanent cards in your graveyard. Roll a d20 and add the total mana value of those cards.<br>1-14 | Return those cards to your hand.<br>15+ | Return those cards to your hand. You gain life equal to their total mana value";
    }

    private SongOfInspirationEffect(SongOfInspirationEffect effect) {
        super((OneShotEffect)effect);
    }

    public SongOfInspirationEffect copy() {
        return new SongOfInspirationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl((Collection)this.getTargetPointer().getTargets(game, source));
        int totalMv = cards.getCards(game).stream().mapToInt(MageObject::getManaValue).sum();
        int result = player.rollDice(this.outcome, source, game, 20);
        player.moveCards((Cards)cards, Zone.HAND, source, game);
        if (result + totalMv >= 15) {
            player.gainLife(totalMv, game, source);
        }
        return true;
    }
}

