/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Library;
import mage.players.Player;

class SongbirdsBlessingEffect
extends OneShotEffect {
    SongbirdsBlessingEffect() {
        super(Outcome.Benefit);
        this.staticText = "reveal cards from the top of your library until you reveal an Aura card. You may put that card onto the battlefield. If you don't, put it into your hand. Put the rest on the bottom of your library in a random order.";
    }

    private SongbirdsBlessingEffect(SongbirdsBlessingEffect effect) {
        super((OneShotEffect)effect);
    }

    public SongbirdsBlessingEffect copy() {
        return new SongbirdsBlessingEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Library library = player.getLibrary();
        if (!library.hasCards()) {
            return true;
        }
        CardsImpl cards = new CardsImpl();
        Card aura = null;
        for (Card card : library.getCards(game)) {
            cards.add(card);
            if (!card.hasSubtype(SubType.AURA, game)) continue;
            aura = card;
            break;
        }
        player.revealCards(source, (Cards)cards, game);
        if (aura != null) {
            if (player.chooseUse(this.outcome, "Put " + aura.getIdName() + " onto the battlefield?", source, game)) {
                player.moveCards(aura, Zone.BATTLEFIELD, source, game);
            } else {
                player.moveCards(aura, Zone.HAND, source, game);
            }
        }
        cards.remove(aura);
        if (!cards.isEmpty()) {
            player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        }
        return true;
    }
}

