/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SonicAssaultEffect
extends OneShotEffect {
    SonicAssaultEffect() {
        super(Outcome.Benefit);
        this.staticText = "Tap target creature. {this} deals 2 damage to that creature's controller.";
    }

    private SonicAssaultEffect(SonicAssaultEffect effect) {
        super((OneShotEffect)effect);
    }

    public SonicAssaultEffect copy() {
        return new SonicAssaultEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent creature = game.getPermanent(source.getFirstTarget());
        if (creature == null) {
            return false;
        }
        creature.tap(source, game);
        Player player = game.getPlayer(creature.getControllerId());
        if (player == null) {
            return false;
        }
        player.damage(2, source.getSourceId(), source, game);
        return true;
    }
}

