/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.MayCastTargetCardEffect;
import mage.constants.CastManaAdjustment;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.common.FilterInstantOrSorceryCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.card.OwnerIdPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInGraveyard;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class SorcerousSquallEffect
extends OneShotEffect {
    SorcerousSquallEffect() {
        super(Outcome.Detriment);
        this.setText("you may cast an instant or sorcery spell from that player's graveyard without paying its mana cost. If that spell would be put into a graveyard, exile it instead.");
    }

    private SorcerousSquallEffect(SorcerousSquallEffect effect) {
        super((OneShotEffect)effect);
    }

    public SorcerousSquallEffect copy() {
        return new SorcerousSquallEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        FilterInstantOrSorceryCard filter = new FilterInstantOrSorceryCard("instant or sorcery card from that player's graveyard");
        filter.add((Predicate)new OwnerIdPredicate(source.getFirstTarget()));
        TargetCardInGraveyard target = new TargetCardInGraveyard(0, 1, (FilterCard)filter, true);
        if (player.choose(this.outcome, (Target)target, source, game)) {
            MayCastTargetCardEffect effect = new MayCastTargetCardEffect(CastManaAdjustment.WITHOUT_PAYING_MANA_COST, true);
            effect.setTargetPointer((TargetPointer)new FixedTarget(target.getFirstTarget(), game));
            effect.apply(game, source);
        }
        return true;
    }
}

