/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.DeathtouchAbility;
import mage.abilities.keyword.LifelinkAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class SorinImperiousBloodlordEffect
extends OneShotEffect {
    SorinImperiousBloodlordEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target creature you control gains deathtouch and lifelink until end of turn. If it's a Vampire, put a +1/+1 counter on it.";
    }

    private SorinImperiousBloodlordEffect(SorinImperiousBloodlordEffect effect) {
        super((OneShotEffect)effect);
    }

    public SorinImperiousBloodlordEffect copy() {
        return new SorinImperiousBloodlordEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        if (permanent.hasSubtype(SubType.VAMPIRE, game)) {
            permanent.addCounters(CounterType.P1P1.createInstance(), source.getControllerId(), source, game);
        }
        game.addEffect((ContinuousEffect)new GainAbilityTargetEffect((Ability)DeathtouchAbility.getInstance(), Duration.EndOfTurn), source);
        game.addEffect((ContinuousEffect)new GainAbilityTargetEffect((Ability)LifelinkAbility.getInstance(), Duration.EndOfTurn), source);
        return true;
    }
}

