/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;

class SorinLordOfInnistradEffect
extends OneShotEffect {
    SorinLordOfInnistradEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "Destroy up to three target creatures and/or other planeswalkers. Return each card put into a graveyard this way to the battlefield under your control";
    }

    private SorinLordOfInnistradEffect(SorinLordOfInnistradEffect effect) {
        super((OneShotEffect)effect);
    }

    public SorinLordOfInnistradEffect copy() {
        return new SorinLordOfInnistradEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        HashSet<Card> toBattlefield = new HashSet<Card>();
        for (UUID targetId : ((Target)source.getTargets().get(0)).getTargets()) {
            Card card;
            Permanent perm = game.getPermanent(targetId);
            if (perm == null) continue;
            perm.destroy(source, game, false);
            if (Zone.GRAVEYARD != game.getState().getZone(targetId) || (card = game.getCard(targetId)) == null) continue;
            toBattlefield.add(card);
        }
        game.processAction();
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            return controller.moveCards(toBattlefield, Zone.BATTLEFIELD, source, game);
        }
        return false;
    }
}

