/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.VampireKnightToken;
import mage.players.Player;
import mage.players.PlayerList;

class SorinTokenEffect
extends OneShotEffect {
    SorinTokenEffect() {
        super(Outcome.GainLife);
        this.staticText = "Create a number of 1/1 black Vampire Knight creature tokens with lifelink equal to the highest life total among all players";
    }

    private SorinTokenEffect(SorinTokenEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        int maxLife = 0;
        PlayerList playerList = game.getState().getPlayersInRange(source.getControllerId(), game);
        for (UUID pid : playerList) {
            Player p = game.getPlayer(pid);
            if (p == null || maxLife >= p.getLife()) continue;
            maxLife = p.getLife();
        }
        new CreateTokenEffect((Token)new VampireKnightToken(), maxLife).apply(game, source);
        return true;
    }

    public SorinTokenEffect copy() {
        return new SorinTokenEffect(this);
    }
}

