/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.ManaUtil;

class SoulBarrierEffect
extends OneShotEffect {
    SoulBarrierEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals 2 damage to that player unless they pay {2}";
    }

    private SoulBarrierEffect(SoulBarrierEffect effect) {
        super((OneShotEffect)effect);
    }

    public SoulBarrierEffect copy() {
        return new SoulBarrierEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (player != null && permanent != null) {
            ManaCost cost = ManaUtil.createManaCost((int)2, (boolean)false);
            if (!player.chooseUse(Outcome.Benefit, "Pay {2}?", source, game) || !cost.pay(source, game, source, player.getId(), false, null)) {
                player.damage(2, source.getSourceId(), source, game);
            }
            return true;
        }
        return false;
    }
}

