/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class SoulFoundryEffect
extends OneShotEffect {
    SoulFoundryEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Create a token that's a copy of the exiled card. X is the mana value of that card";
    }

    private SoulFoundryEffect(SoulFoundryEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Card imprinted;
        Permanent soulFoundry;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && (soulFoundry = game.getPermanentOrLKIBattlefield(source.getSourceId())) != null && soulFoundry.getImprinted() != null && !soulFoundry.getImprinted().isEmpty() && (imprinted = game.getCard((UUID)soulFoundry.getImprinted().get(0))) != null && game.getState().getZone(imprinted.getId()) == Zone.EXILED) {
            CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect();
            effect.setTargetPointer((TargetPointer)new FixedTarget(imprinted.getId(), imprinted.getZoneChangeCounter(game)));
            return effect.apply(game, source);
        }
        return false;
    }

    public SoulFoundryEffect copy() {
        return new SoulFoundryEffect(this);
    }
}

