/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Controllable;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.Angel33Token;

class SoulOfEmancipationEffect
extends OneShotEffect {
    SoulOfEmancipationEffect() {
        super(Outcome.Benefit);
        this.staticText = "destroy up to three other target nonland permanents. For each of those permanents, its controller creates a 3/3 white Angel creature token with flying";
    }

    private SoulOfEmancipationEffect(SoulOfEmancipationEffect effect) {
        super((OneShotEffect)effect);
    }

    public SoulOfEmancipationEffect copy() {
        return new SoulOfEmancipationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        List permanents = this.getTargetPointer().getTargets(game, source).stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        if (permanents.isEmpty()) {
            return false;
        }
        Map<UUID, Integer> playerMap = permanents.stream().collect(Collectors.toMap(Controllable::getControllerId, x -> 1, Integer::sum));
        for (Permanent permanent : permanents) {
            permanent.destroy(source, game);
        }
        for (Map.Entry entry : playerMap.entrySet()) {
            new Angel33Token().putOntoBattlefield(((Integer)entry.getValue()).intValue(), game, source, (UUID)entry.getKey());
        }
        return true;
    }
}

