/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SoulRansomEffect
extends OneShotEffect {
    SoulRansomEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this}'s controller sacrifices it, then draws two cards. Only your opponents may activate this ability";
    }

    private SoulRansomEffect(SoulRansomEffect effect) {
        super((OneShotEffect)effect);
    }

    public SoulRansomEffect copy() {
        return new SoulRansomEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent != null) {
            permanent.sacrifice(source, game);
        } else {
            permanent = (Permanent)game.getLastKnownInformation(source.getSourceId(), Zone.BATTLEFIELD);
        }
        if (permanent == null) {
            return false;
        }
        Player controller = game.getPlayer(permanent.getControllerId());
        if (controller == null) {
            return false;
        }
        controller.drawCards(2, source, game);
        return true;
    }
}

