/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.s.SoulReapWatcher;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SoulReapEffect
extends OneShotEffect {
    SoulReapEffect() {
        super(Outcome.Detriment);
        this.staticText = "destroy target nongreen creature. Its controller loses 3 life if you've cast another black spell this turn";
    }

    private SoulReapEffect(SoulReapEffect effect) {
        super((OneShotEffect)effect);
    }

    public SoulReapEffect copy() {
        return new SoulReapEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent creature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (creature == null) {
            return false;
        }
        creature.destroy(source, game);
        if (!SoulReapWatcher.checkSpell(source, game)) {
            return true;
        }
        Player controller = game.getPlayer(creature.getControllerId());
        if (controller != null) {
            controller.loseLife(3, game, source, false);
        }
        return true;
    }
}

