/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class SoulSeizerEffect
extends OneShotEffect {
    SoulSeizerEffect() {
        super(Outcome.GainControl);
        this.staticText = "you may transform it. If you do, attach it to target creature that player controls";
    }

    private SoulSeizerEffect(SoulSeizerEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null || !permanent.transform(source, game)) {
            return false;
        }
        Permanent attachTo = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        return attachTo != null && attachTo.addAttachment(permanent.getId(), source, game);
    }

    public SoulSeizerEffect copy() {
        return new SoulSeizerEffect(this);
    }
}

