/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.common.AttacksAllTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.DeathtouchAbility;
import mage.constants.Duration;
import mage.constants.SetTargetPointer;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class SoulbladeCorrupterTriggeredAbility
extends AttacksAllTriggeredAbility {
    SoulbladeCorrupterTriggeredAbility() {
        super((Effect)new GainAbilityTargetEffect((Ability)DeathtouchAbility.getInstance(), Duration.EndOfTurn).setText("that creature gains deathtouch until end of turn"), false, StaticFilters.FILTER_CREATURE_P1P1, SetTargetPointer.PERMANENT, false);
    }

    private SoulbladeCorrupterTriggeredAbility(SoulbladeCorrupterTriggeredAbility effect) {
        super((AttacksAllTriggeredAbility)effect);
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (super.checkTrigger(event, game)) {
            Player defender = game.getPlayer(event.getTargetId());
            if (defender == null) {
                return false;
            }
            Set opponents = game.getOpponents(this.getControllerId());
            if (opponents != null && opponents.contains(defender.getId())) {
                for (Effect effect : this.getEffects()) {
                    effect.setTargetPointer((TargetPointer)new FixedTarget(event.getSourceId(), game));
                }
                return true;
            }
        }
        return false;
    }

    public String getRule() {
        return "Whenever a creature with a +1/+1 counter on it attacks one of your opponents, that creature gains deathtouch until end of turn.";
    }

    public SoulbladeCorrupterTriggeredAbility copy() {
        return new SoulbladeCorrupterTriggeredAbility(this);
    }
}

