/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.s.SoulfireEruptionCastEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class SoulfireEruptionEffect
extends OneShotEffect {
    SoulfireEruptionEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose any number of target creatures, planeswalkers, and/or players. For each of them, exile the top card of your library, then {this} deals damage equal to that card's mana value to that permanent or player. You may play the exiled cards until the end of your next turn";
    }

    private SoulfireEruptionEffect(SoulfireEruptionEffect effect) {
        super((OneShotEffect)effect);
    }

    public SoulfireEruptionEffect copy() {
        return new SoulfireEruptionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        for (UUID targetId : source.getTargets().stream().map(Target::getTargets).flatMap(Collection::stream).collect(Collectors.toSet())) {
            Card card;
            Permanent permanent = game.getPermanent(targetId);
            Player player = game.getPlayer(targetId);
            if (permanent == null && player == null || (card = controller.getLibrary().getFromTop(game)) == null) continue;
            controller.moveCards(card, Zone.EXILED, source, game);
            game.addEffect(new SoulfireEruptionCastEffect().setTargetPointer((TargetPointer)new FixedTarget(card, game)), source);
            if (card.getManaValue() < 1) continue;
            if (permanent != null) {
                permanent.damage(card.getManaValue(), source.getSourceId(), source, game);
            }
            if (player == null) continue;
            player.damage(card.getManaValue(), source.getSourceId(), source, game);
        }
        return true;
    }
}

