/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.DeathtouchAbility;
import mage.abilities.keyword.DoubleStrikeAbility;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.abilities.keyword.FlyingAbility;
import mage.abilities.keyword.HasteAbility;
import mage.abilities.keyword.HexproofAbility;
import mage.abilities.keyword.HexproofBaseAbility;
import mage.abilities.keyword.IndestructibleAbility;
import mage.abilities.keyword.LifelinkAbility;
import mage.abilities.keyword.ReachAbility;
import mage.abilities.keyword.TrampleAbility;
import mage.abilities.keyword.VigilanceAbility;
import mage.cards.Card;
import mage.cards.Cards;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class SoulflayerEffect
extends ContinuousEffectImpl {
    private Set<Ability> abilitiesToAdd;
    private MageObjectReference objectReference = null;

    public SoulflayerEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "If a creature card with flying was exiled with {this}'s delve ability, {this} has flying. The same is true for first strike, double strike, deathtouch, haste, hexproof, indestructible, lifelink, reach, trample, and vigilance";
        this.abilitiesToAdd = null;
    }

    private SoulflayerEffect(SoulflayerEffect effect) {
        super((ContinuousEffectImpl)effect);
        if (effect.abilitiesToAdd != null) {
            this.abilitiesToAdd = new HashSet<Ability>();
            for (Ability a : effect.abilitiesToAdd) {
                this.abilitiesToAdd.add(a.copy());
            }
        }
        this.objectReference = effect.objectReference;
    }

    public SoulflayerEffect copy() {
        return new SoulflayerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent != null) {
            if (this.objectReference == null || !this.objectReference.refersTo((MageObject)permanent, game)) {
                this.abilitiesToAdd = new HashSet<Ability>();
                this.objectReference = new MageObjectReference((MageObject)permanent, game);
                String keyString = CardUtil.getCardZoneString((String)"delvedCards", (UUID)source.getSourceId(), (Game)game, (boolean)true);
                Cards delvedCards = (Cards)game.getState().getValue(keyString);
                if (delvedCards != null) {
                    for (Card card : delvedCards.getCards(game)) {
                        if (!card.isCreature(game)) continue;
                        for (Ability cardAbility : card.getAbilities(game)) {
                            if (cardAbility instanceof FlyingAbility) {
                                this.abilitiesToAdd.add((Ability)FlyingAbility.getInstance());
                            }
                            if (cardAbility instanceof FirstStrikeAbility) {
                                this.abilitiesToAdd.add((Ability)FirstStrikeAbility.getInstance());
                            }
                            if (cardAbility instanceof DoubleStrikeAbility) {
                                this.abilitiesToAdd.add((Ability)DoubleStrikeAbility.getInstance());
                            }
                            if (cardAbility instanceof DeathtouchAbility) {
                                this.abilitiesToAdd.add((Ability)DeathtouchAbility.getInstance());
                            }
                            if (cardAbility instanceof HasteAbility) {
                                this.abilitiesToAdd.add((Ability)HasteAbility.getInstance());
                            }
                            if (cardAbility instanceof HexproofBaseAbility) {
                                this.abilitiesToAdd.add((Ability)HexproofAbility.getInstance());
                            }
                            if (cardAbility instanceof IndestructibleAbility) {
                                this.abilitiesToAdd.add((Ability)IndestructibleAbility.getInstance());
                            }
                            if (cardAbility instanceof LifelinkAbility) {
                                this.abilitiesToAdd.add((Ability)LifelinkAbility.getInstance());
                            }
                            if (cardAbility instanceof ReachAbility) {
                                this.abilitiesToAdd.add((Ability)ReachAbility.getInstance());
                            }
                            if (cardAbility instanceof TrampleAbility) {
                                this.abilitiesToAdd.add((Ability)TrampleAbility.getInstance());
                            }
                            if (!(cardAbility instanceof VigilanceAbility)) continue;
                            this.abilitiesToAdd.add((Ability)VigilanceAbility.getInstance());
                        }
                    }
                }
            }
            for (Ability ability : this.abilitiesToAdd) {
                permanent.addAbility(ability, source.getSourceId(), game);
            }
            return true;
        }
        if (this.abilitiesToAdd != null) {
            this.abilitiesToAdd = null;
        }
        return false;
    }
}

