/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.LinkedHashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreatureCard;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SoulquakeEffect
extends OneShotEffect {
    private static final FilterCreatureCard filter2 = new FilterCreatureCard("creature");

    public SoulquakeEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "Return all creatures on the battlefield and all creature cards in graveyards to their owners' hands";
    }

    private SoulquakeEffect(SoulquakeEffect effect) {
        super((OneShotEffect)effect);
    }

    public SoulquakeEffect copy() {
        return new SoulquakeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        LinkedHashSet<Object> cardsToHand = new LinkedHashSet<Object>();
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), source, game)) {
            cardsToHand.add(permanent);
        }
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            for (Card card : player.getGraveyard().getCards((FilterCard)filter2, game)) {
                cardsToHand.add(card);
            }
        }
        return controller.moveCards(cardsToHand, Zone.HAND, source, game);
    }
}

