/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.SavedDamageValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class SoulsOfTheFaultlessEffect
extends OneShotEffect {
    SoulsOfTheFaultlessEffect() {
        super(Outcome.LoseLife);
        this.staticText = "and attacking player loses that much life";
    }

    private SoulsOfTheFaultlessEffect(SoulsOfTheFaultlessEffect effect) {
        super((OneShotEffect)effect);
    }

    public SoulsOfTheFaultlessEffect copy() {
        return new SoulsOfTheFaultlessEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int amount = SavedDamageValue.MUCH.calculate(game, source, (Effect)this);
        Player attacker = game.getPlayer(game.getActivePlayerId());
        if (attacker != null) {
            attacker.loseLife(amount, game, source, false);
        }
        return true;
    }
}

