/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class SovereignOkinecAhauEffect
extends OneShotEffect {
    SovereignOkinecAhauEffect() {
        super(Outcome.Benefit);
        this.staticText = "for each creature you control with power greater than that creature's base power, put a number of +1/+1 counters on that creature equal to the difference.";
    }

    private SovereignOkinecAhauEffect(SovereignOkinecAhauEffect effect) {
        super((OneShotEffect)effect);
    }

    public SovereignOkinecAhauEffect copy() {
        return new SovereignOkinecAhauEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, source.getControllerId(), source, game)) {
            int powerDiff = permanent.getPower().getValue() - permanent.getPower().getModifiedBaseValue();
            if (powerDiff <= 0) continue;
            permanent.addCounters(CounterType.P1P1.createInstance(powerDiff), source.getControllerId(), source, game);
        }
        return true;
    }
}

