/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.common.EntersBattlefieldAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.constants.SuperType;
import mage.counters.CounterType;
import mage.game.Game;
import mage.util.functions.CopyApplier;

class SparkDoubleCopyApplier
extends CopyApplier {
    SparkDoubleCopyApplier() {
    }

    public String getText() {
        return ", except it enters with an additional +1/+1 counter on it if it's a creature, it enters with an additional loyalty counter on it if it's a planeswalker, and it isn't legendary";
    }

    public boolean apply(Game game, MageObject blueprint, Ability source, UUID copyToObjectId) {
        blueprint.removeSuperType(SuperType.LEGENDARY);
        if (!this.isCopyOfCopy(source, blueprint, copyToObjectId)) {
            if (blueprint.isCreature(game)) {
                blueprint.getAbilities().add((Object)new EntersBattlefieldAbility((Effect)new AddCountersSourceEffect(CounterType.P1P1.createInstance(), false).setText("with an additional +1/+1 counter on it")));
            }
            if (blueprint.isPlaneswalker(game)) {
                blueprint.getAbilities().add((Object)new EntersBattlefieldAbility((Effect)new AddCountersSourceEffect(CounterType.LOYALTY.createInstance(), false).setText("with an additional loyalty counter on it")));
            }
        }
        return true;
    }
}

