/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class SparkFiendUpkeepEffect
extends OneShotEffect {
    SparkFiendUpkeepEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "roll two six-sided dice. If you rolled 7, sacrifice {this}. If you roll the noted total, don't roll dice for {this} during any of your following upkeeps. Otherwise, do nothing";
    }

    private SparkFiendUpkeepEffect(SparkFiendUpkeepEffect effect) {
        super((OneShotEffect)effect);
    }

    public SparkFiendUpkeepEffect copy() {
        return new SparkFiendUpkeepEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            if (game.getState().getValue("SparkFiend" + source.getSourceId().toString()) != null && (Integer)game.getState().getValue("SparkFiend" + source.getSourceId().toString()) != 0) {
                int roll = controller.rollDice(this.outcome, source, game, 6, 2, 0).stream().mapToInt(x -> x).sum();
                MageObject mageObject = game.getObject(source);
                if (mageObject instanceof Permanent) {
                    Permanent sourcePermanent = (Permanent)mageObject;
                    if (roll == 7) {
                        sourcePermanent.sacrifice(source, game);
                    } else if (roll == (Integer)game.getState().getValue("SparkFiend" + source.getSourceId().toString())) {
                        game.getState().setValue("SparkFiend" + source.getSourceId().toString(), (Object)0);
                        sourcePermanent.addInfo("roll counter", CardUtil.addToolTipMarkTags((String)""), game);
                    }
                }
            }
            return true;
        }
        return false;
    }
}

