/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.TreasureToken;
import mage.game.stack.StackObject;

class SpellSwindleEffect
extends OneShotEffect {
    SpellSwindleEffect() {
        super(Outcome.Detriment);
        this.staticText = "Counter target spell. Create X Treasure tokens, where X is that spell's mana value.";
    }

    private SpellSwindleEffect(SpellSwindleEffect effect) {
        super((OneShotEffect)effect);
    }

    public SpellSwindleEffect copy() {
        return new SpellSwindleEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        StackObject stackObject = game.getStack().getStackObject(this.getTargetPointer().getFirst(game, source));
        if (stackObject != null) {
            game.getStack().counter(source.getFirstTarget(), source, game);
            return new TreasureToken().putOntoBattlefield(stackObject.getManaValue(), game, source);
        }
        return false;
    }
}

