/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.filter.FilterPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.game.stack.StackObject;
import mage.players.Player;
import mage.util.ManaUtil;

class SpellSyphonEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent("blue permanent you control");

    public SpellSyphonEffect() {
        super(Outcome.Detriment);
        this.staticText = "Counter target spell unless its controller pays {1} for each blue permanent you control";
    }

    private SpellSyphonEffect(SpellSyphonEffect effect) {
        super((OneShotEffect)effect);
    }

    public SpellSyphonEffect copy() {
        return new SpellSyphonEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        StackObject spell = game.getStack().getStackObject(this.getTargetPointer().getFirst(game, source));
        if (spell != null) {
            Player player = game.getPlayer(spell.getControllerId());
            Player controller = game.getPlayer(source.getControllerId());
            if (player != null && controller != null) {
                int amount = game.getBattlefield().count(filter, controller.getId(), source, game);
                if (amount == 0) {
                    game.informPlayers("Spell Syphon: no blue permanents in controller's battlefield.");
                } else {
                    ManaCost cost = ManaUtil.createManaCost((int)amount, (boolean)false);
                    if (!cost.pay(source, game, source, spell.getControllerId(), false)) {
                        game.informPlayers("Spell Syphon: cost wasn't payed - countering target spell.");
                        return game.getStack().counter(source.getFirstTarget(), source, game);
                    }
                }
            }
        }
        return false;
    }

    static {
        filter.add((Predicate)new ColorPredicate(ObjectColor.BLUE));
        filter.add((ObjectSourcePlayerPredicate)TargetController.YOU.getControllerPredicate());
    }
}

