/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class SpellpyrePhoenixWatcher
extends Watcher {
    private final Map<UUID, Integer> cycleMap = new HashMap<UUID, Integer>();

    SpellpyrePhoenixWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.CYCLED_CARD) {
            this.cycleMap.merge(event.getPlayerId(), 1, Integer::sum);
        }
    }

    public void reset() {
        super.reset();
        this.cycleMap.clear();
    }

    boolean checkCycleCount(UUID playerId) {
        return this.cycleMap.getOrDefault(playerId, 0) >= 2;
    }

    int getCycleCount(UUID playerId) {
        return this.cycleMap.getOrDefault(playerId, 0);
    }
}

