/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.ApprovingObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

class SpellshiftEffect
extends OneShotEffect {
    SpellshiftEffect() {
        super(Outcome.Detriment);
        this.staticText = "Its controller reveals cards from the top of their library until they reveal an instant or sorcery card. That player may cast that card without paying its mana cost. Then the player shuffles";
    }

    private SpellshiftEffect(SpellshiftEffect effect) {
        super((OneShotEffect)effect);
    }

    public SpellshiftEffect copy() {
        return new SpellshiftEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player spellController = game.getPlayer(((Spell)game.getLastKnownInformation(this.getTargetPointer().getFirst(game, source), Zone.STACK)).getControllerId());
        if (spellController != null) {
            CardsImpl cardsToReveal = new CardsImpl();
            Card toCast = null;
            for (Card card : spellController.getLibrary().getCards(game)) {
                cardsToReveal.add(card);
                if (!card.isSorcery(game) && !card.isInstant(game)) continue;
                toCast = card;
                break;
            }
            spellController.revealCards(source, (Cards)cardsToReveal, game);
            if (toCast != null && spellController.chooseUse(this.outcome, "Cast " + toCast.getLogName() + " without paying its mana cost?", source, game)) {
                game.getState().setValue("PlayFromNotOwnHandZone" + toCast.getId(), (Object)Boolean.TRUE);
                spellController.cast(spellController.chooseAbilityForCast(toCast, game, true), game, true, new ApprovingObject(source, game));
                game.getState().setValue("PlayFromNotOwnHandZone" + toCast.getId(), null);
            }
            spellController.shuffleLibrary(source, game);
            return true;
        }
        return false;
    }
}

