/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.Card;
import mage.cards.s.SpellweaverHelixCastEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class SpellweaverHelixTriggeredAbility
extends TriggeredAbilityImpl {
    SpellweaverHelixTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new SpellweaverHelixCastEffect(), false);
    }

    private SpellweaverHelixTriggeredAbility(SpellweaverHelixTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public SpellweaverHelixTriggeredAbility copy() {
        return new SpellweaverHelixTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Spell spell = game.getStack().getSpell(event.getTargetId());
        if (spell != null && spell.getCard() != null && !spell.getCard().isCopy()) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(spell.getId()));
            }
            return true;
        }
        return false;
    }

    public boolean checkInterveningIfClause(Game game) {
        Spell spell = game.getStack().getSpell(((Effect)this.getEffects().get(0)).getTargetPointer().getFirst(game, (Ability)this));
        if (spell != null) {
            String spellName = spell.getName();
            Permanent sourcePermanent = game.getPermanent(this.getSourceId());
            if (sourcePermanent != null) {
                for (UUID imprintId : sourcePermanent.getImprinted()) {
                    Card card = game.getCard(imprintId);
                    if (card == null || !card.getName().equals(spellName)) continue;
                    ((SpellweaverHelixCastEffect)((Object)this.getEffects().get(0))).setSpellName(spellName);
                    return true;
                }
            }
        }
        return false;
    }

    public String getRule() {
        return "Whenever a player casts a card, if it has the same name as one of the cards exiled with {this}, you may copy the other. If you do, you may cast the copy without paying its mana cost.";
    }
}

