/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;

class SpelunkingEffect
extends OneShotEffect {
    SpelunkingEffect() {
        super(Outcome.Benefit);
        this.staticText = ", then you may put a land card from your hand onto the battlefield. If you put a Cave onto the battlefield this way, you gain 4 life";
    }

    private SpelunkingEffect(SpelunkingEffect effect) {
        super((OneShotEffect)effect);
    }

    public SpelunkingEffect copy() {
        return new SpelunkingEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TargetCardInHand target = new TargetCardInHand(0, 1, (FilterCard)StaticFilters.FILTER_CARD_LAND);
        controller.choose(Outcome.PutLandInPlay, (Target)target, source, game);
        Card landInHand = game.getCard(target.getFirstTarget());
        if (landInHand == null) {
            return false;
        }
        controller.moveCards(landInHand, Zone.BATTLEFIELD, source, game);
        if (landInHand.hasSubtype(SubType.CAVE, game)) {
            controller.gainLife(4, game, source);
        }
        return true;
    }
}

