/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SphinxBoneWandEffect
extends OneShotEffect {
    SphinxBoneWandEffect() {
        super(Outcome.Damage);
        this.staticText = "put a charge counter on {this}. If you do, {this} deals damage equal to the number of charge counters on it to any target";
    }

    private SphinxBoneWandEffect(SphinxBoneWandEffect effect) {
        super((OneShotEffect)effect);
    }

    public SphinxBoneWandEffect copy() {
        return new SphinxBoneWandEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        if (sourcePermanent != null) {
            Player player;
            sourcePermanent.addCounters(CounterType.CHARGE.createInstance(), source.getControllerId(), source, game);
            int amount = sourcePermanent.getCounters(game).getCount(CounterType.CHARGE);
            Permanent permanent = game.getPermanent(source.getFirstTarget());
            if (permanent != null) {
                permanent.damage(amount, source.getSourceId(), source, game, false, true);
            }
            if ((player = game.getPlayer(source.getFirstTarget())) != null) {
                player.damage(amount, source.getSourceId(), source, game);
            }
            return true;
        }
        return false;
    }
}

