/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import mage.abilities.Ability;
import mage.constants.WatcherScope;
import mage.game.Controllable;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.util.CardUtil;
import mage.watchers.Watcher;

class SpiderUKWatcher
extends Watcher {
    private final Map<UUID, Integer> map = new HashMap<UUID, Integer>();

    SpiderUKWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.ENTERS_THE_BATTLEFIELD) {
            return;
        }
        Optional.of(event).map(EntersTheBattlefieldEvent.class::cast).map(EntersTheBattlefieldEvent::getTarget).map(Controllable::getControllerId).ifPresent(uuid -> this.map.compute((UUID)uuid, CardUtil::setOrIncrementValue));
    }

    public void reset() {
        super.reset();
        this.map.clear();
    }

    static boolean checkPlayer(Game game, Ability source) {
        return ((SpiderUKWatcher)game.getState().getWatcher(SpiderUKWatcher.class)).map.getOrDefault(source.getControllerId(), 0) >= 2;
    }
}

