/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SpikeshellHarrierEffect
extends OneShotEffect {
    SpikeshellHarrierEffect() {
        super(Outcome.Benefit);
        this.staticText = "return target creature or Vehicle an opponent controls to its owner's hand. If that opponent's speed is greater than each other player's speed, reduce that opponent's speed by 1. This effect can't reduce their speed below 1";
    }

    private SpikeshellHarrierEffect(SpikeshellHarrierEffect effect) {
        super((OneShotEffect)effect);
    }

    public SpikeshellHarrierEffect copy() {
        return new SpikeshellHarrierEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        Player player = game.getPlayer(permanent.getControllerId());
        if (player == null) {
            return false;
        }
        player.moveCards((Card)permanent, Zone.HAND, source, game);
        int minSpeed = game.getState().getPlayersInRange(source.getControllerId(), game).stream().filter(uuid -> !uuid.equals(player.getId())).map(arg_0 -> ((Game)game).getPlayer(arg_0)).mapToInt(Player::getSpeed).min().orElse(0);
        if (player.getSpeed() > minSpeed) {
            player.decreaseSpeed(game);
        }
        return true;
    }
}

