/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SpinalEmbraceSacrificeEffect
extends OneShotEffect {
    SpinalEmbraceSacrificeEffect() {
        super(Outcome.Benefit);
        this.staticText = "sacrifice it. If you do, you gain life equal to its toughness";
    }

    private SpinalEmbraceSacrificeEffect(SpinalEmbraceSacrificeEffect effect) {
        super((OneShotEffect)effect);
    }

    public SpinalEmbraceSacrificeEffect copy() {
        return new SpinalEmbraceSacrificeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int affectedTargets = 0;
        for (UUID permanentId : this.getTargetPointer().getTargets(game, source)) {
            Permanent permanent = game.getPermanent(permanentId);
            if (permanent == null) continue;
            permanent.sacrifice(source, game);
            ++affectedTargets;
            Player controller = game.getPlayer(source.getControllerId());
            if (controller == null) continue;
            controller.gainLife(permanent.getPower().getValue(), game, source);
        }
        return affectedTargets > 0;
    }
}

