/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashMap;
import java.util.Map;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.util.CardUtil;
import mage.watchers.Watcher;

class SpinyStarfishWatcher
extends Watcher {
    private final Map<MageObjectReference, Integer> regeneratedCount = new HashMap<MageObjectReference, Integer>();

    public SpinyStarfishWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.REGENERATED) {
            this.regeneratedCount.compute(new MageObjectReference(event.getTargetId(), game), CardUtil::setOrIncrementValue);
        }
    }

    public void reset() {
        super.reset();
        this.regeneratedCount.clear();
    }

    static int regeneratedCount(Game game, Ability source) {
        return ((SpinyStarfishWatcher)game.getState().getWatcher(SpinyStarfishWatcher.class)).regeneratedCount.getOrDefault(new MageObjectReference((MageObject)source.getSourcePermanentOrLKI(game), game), 0);
    }
}

